/*
 * Created on Nov 10, 2005
 *
 * $Id: JDomOutputterUtil.java,v 1.6 2006/01/26 18:13:38 dec Exp $
 */
package ericResponse.output;

import java.io.IOException;
import java.io.Writer;

import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * @author rob
 */
public class JDomOutputterUtil {

    private JDomOutputterUtil() {
        // prevent construction
    }

    /**
     * write out the xml contained in the document to the stream
     * 
     * @param output
     *            the output stream that we are going to write into
     * @param document
     *            the document containing the xml
     * @param format
     *            The format of the xml
     */
    public static void writeToOutput(final Writer output, final Document document, final Format format) {
        final XMLOutputter outputter;

        if (format == null) {
            outputter = new XMLOutputter();
        } else {
            outputter = new XMLOutputter(format);
        }

        try {
            outputter.output(document, output);
        } catch (final IOException f) {
            f.printStackTrace();
        }
    }

    /**
     * write out the xml contained in the document to the stream
     * 
     * @param output
     *            the output stream that we are going to write into
     * @param document
     *            the document containing the xml
     */
    public static void writeToOutput(final Writer output, final Document document) {
        writeToOutput(output, document, null);
    }

}
