package ericResponse.output;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Attribute;
import org.jdom.Element;

import ericResponse.output.error.EricResponseError;

public class PAYESuccessResponseGenerator implements ResponseElementGenerator {

    private static final String[][] SUCCESS_RESPONSES = {
            { "P14Part", "9003", "This P14 submission has been accepted and is awaiting further processing" },
            { "P35Part", "9004", "The EOY Return has been processed and passed full validation" },
            { "complete", "9004", "The EOY Return has been processed and passed full validation" },
            { "consolidated", "9004", "The EOY Return has been processed and passed full validation" } };

    private final IREnvelopeDetails irEnvelopeDetails;

    private final PAYESubmissionDetails payeSubmissionDetails;

    public PAYESuccessResponseGenerator(final IREnvelopeDetails irEnvelopeDetails, final PAYESubmissionDetails payeSubmissionDetails) {
        this.irEnvelopeDetails = irEnvelopeDetails;
        this.payeSubmissionDetails = payeSubmissionDetails;
    }

    public List<Element> generateResponse(final List<Element> children, final List<EricResponseError> ericErrors,
            final EricResponseParams params) {
        /*
         * If there are errors present then we've got nothing to do, so return
         * null.
         */
        if (!ericErrors.isEmpty()) {
            return null;
        }

        final List<Element> list = new ArrayList<Element>(2);

        if (irEnvelopeDetails.isTestMessage()) {
            final Element message = new Element("Message", SuccessResponseGenerator.NAMESPACE_SUCCESS_RESPONSE);
            message.setAttribute(new Attribute("code", "9001"));
            message.addContent("This submission would have been successfully processed if sent under non test conditions.");
            list.add(message);
        }

        final Element message = new Element("Message", SuccessResponseGenerator.NAMESPACE_SUCCESS_RESPONSE);
        for (final String[] row : SUCCESS_RESPONSES) {
            if (row[0].equals(payeSubmissionDetails.getSubmissionType())) {
                message.setAttribute(new Attribute("code", row[1]));
                message.addContent(row[2]);
                break;
            }
        }
        list.add(message);

        return list;
    }
}
