package ericResponse.output;

import java.util.List;

import org.jdom.Element;
import org.jdom.Namespace;

import com.gsl.docValidator.ValidatorProvider;

import ericResponse.output.error.EricResponseError;

/**
 * Implementations of this interface are responsible for generating elements of
 * the validation XML response document. Generator instances may be registered
 * prior to the response being generated (it is generally the responsibility of
 * the registered {@link ValidatorProvider}s to register the required
 * generators via calls to
 * {@link EricResponsePostValidationDelegate#addResponseGenerator(ResponseElementGenerator)}.
 * <p>
 * The current API contract for implementing and registering generators to get
 * the desired output response is somewhat non-intuitive. Generators are invoked
 * sequentially in the reverse order they were registered. Each one returns a
 * list of 'child' XML elements, which are passed to the next generator to be
 * invoked. It is the responsbility of the following generator to add the
 * children that it gets passed at the appropriate location within its own
 * generated XML elements. It then returns these elements, which are passed as
 * children to the next generator, and so on. So, effectively the list of
 * registered generators forms a nested structure, with the first generator to
 * be registered forming the outer-most XML element(s), and the last generator
 * forming the inner-most element(s). For this reason, the outer-most generator
 * should generally always return a list containg just a single XML element.
 * Note that the first generator to be invoked is passed null for the list of
 * children to include.
 * <p>
 * Generator implementations may return a null list of children. This indicates
 * that they have nothing to contribute to the response. If a generator returns
 * null, the effect is exactly as if it had never been registered (ie. the
 * response appears as if the generator before it and the generator after it
 * we're actually direct neighbours).
 * <p>
 * The null return semantics are currently used to implement error/success
 * response variants. In other words, it is the responsibilty of the individual
 * generator implementations to check whether the passed in ERIC error error
 * list is empty or not. A generator that is concerned only with success
 * responses should check the list and return null if it is not empty.
 * Conversly, a generator that concerned only with error responses should check
 * the list and return null if the it is empty. Of course, a generator may
 * return something regardless if it is not specific to either error or success
 * repsonses - the GovTalk gateway envelope generator is an example of this.
 * 
 * @author jesse
 */
public interface ResponseElementGenerator {

    public static final Namespace NAMESPACE_XSI = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");

    /**
     * Generates the child XML elements to pass to the next outter-most response
     * element generator that was registered.
     * <p>
     * This method is also responsible for attaching the children elements it
     * gets passed at the appropriate location within the XML elements it
     * generates.
     * 
     * @param children
     *            The XML elements to attach as children within the XML elements
     *            generator by this generator.
     * @param ericErrors
     *            The list of ERIC errors that was produced by the validation
     *            and mapping stages.
     * @param params
     *            The ERIC response params as configured by the client.
     * 
     * @return A list of XML elements to pass as child elements to the next
     *         registered response generator, or null to indicate that this
     *         generator would like to be ignored with respect to the current
     *         response being generated.
     */
    public List<Element> generateResponse(List<Element> children, List<EricResponseError> ericErrors, EricResponseParams params);
}
