package ericResponse.output;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

import com.gsl.docValidator.CurrentDate;

import ericResponse.output.error.EricResponseError;
import govtalk.header.GovTalkHeaderConstants;
import govtalk.header.GovTalkHeaderDetails;

public class SuccessResponseGenerator implements ResponseElementGenerator {

    public static final Namespace NAMESPACE_SUCCESS_RESPONSE = Namespace
            .getNamespace("http://www.inlandrevenue.gov.uk/SuccessResponse");

    private static final String ACCEPTED_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    private final GovTalkHeaderDetails govTalkHeaderDetails;

    private final IREnvelopeDetails irEnvelopeDetails;

    private boolean generateResponseDataEnvelope = false;

    private boolean generateIRmarkReceipt = false;

    private boolean generateAcceptedTime = false;

    public SuccessResponseGenerator(GovTalkHeaderDetails govTalkHeaderDetails, final IREnvelopeDetails irEnvelopeDetails,
            final boolean generateResponseDataEnvelope, final boolean generateIRmarkReceipt, final boolean generateAcceptedTime) {

        if (govTalkHeaderDetails == null) {
            govTalkHeaderDetails = GovTalkHeaderConstants.DEFAULT_GOV_TALK_HEADER_DETAILS;
        }

        this.govTalkHeaderDetails = govTalkHeaderDetails;
        this.irEnvelopeDetails = irEnvelopeDetails;
        this.generateResponseDataEnvelope = generateResponseDataEnvelope;
        this.generateIRmarkReceipt = generateIRmarkReceipt;
        this.generateAcceptedTime = generateAcceptedTime;
    }

    public List<Element> generateResponse(final List<Element> children, final List<EricResponseError> ericErrors,
            final EricResponseParams params) {
        /*
         * If there are errors present then we've got nothing to do, so return
         * null.
         */
        if (!ericErrors.isEmpty()) {
            return null;
        }

        final Element elSuccessResponse = new Element("SuccessResponse", NAMESPACE_SUCCESS_RESPONSE);

        if (irEnvelopeDetails.isTestMessage()) {
            elSuccessResponse.setAttribute(new Attribute("TestInLive", "1"));
        }

        if ((generateIRmarkReceipt || generateAcceptedTime)) {
            final String now = new SimpleDateFormat(ACCEPTED_TIME_FORMAT).format(CurrentDate.getCurrentDate());

            if (generateIRmarkReceipt && irEnvelopeDetails.getIRmark() != null) {
                final Element elIRmarkReceipt = new Element("IRmarkReceipt", NAMESPACE_SUCCESS_RESPONSE);

                elIRmarkReceipt.addContent(IRmarkSignature.createSignature(irEnvelopeDetails.getIRmark()));

                final Element elMessage = new Element("Message", NAMESPACE_SUCCESS_RESPONSE);
                elMessage.setAttribute(new Attribute("code", "1"));
                elMessage.setText("The Inland Revenue has received the " + govTalkHeaderDetails.getMessageClass()
                        + " document ref: " + govTalkHeaderDetails.getTaxOfficeNumber() + " "
                        + govTalkHeaderDetails.getTaxOfficeReference() + " at " + now + ". The associated IRmark was: "
                        + "THIS IS A TEST NOTE: NO SUBMISSION HAS BEEN MADE - To test IRmark fully please use the "
                        + "HMRC CIS TPVS service.");
                elIRmarkReceipt.addContent(elMessage);
                elSuccessResponse.addContent(elIRmarkReceipt);
            }

            if (generateAcceptedTime) {
                final Element elAcceptedTime = new Element("AcceptedTime", NAMESPACE_SUCCESS_RESPONSE);
                elAcceptedTime.setText(now);
                elSuccessResponse.addContent(elAcceptedTime);
            }
        }

        if (generateResponseDataEnvelope) {
            final Element elResponseData = new Element("ResponseData", NAMESPACE_SUCCESS_RESPONSE);
            elResponseData.addContent(children);
            elSuccessResponse.addContent(elResponseData);
        } else {
            elSuccessResponse.addContent(children);
        }

        final List<Element> list = new ArrayList<Element>(1);
        list.add(elSuccessResponse);
        return list;
    }
}

// irEnvelopeDetails.getIRmark()

