/*
 * Created on Nov 26, 2005
 * 
 * $Id: ERErrorDetail.java,v 1.10 2006/06/14 10:00:05 dec Exp $
 */
package ericResponse.output.error;

import hmrc.bizrules.QualityStage;
import processingError.ErrorProcessor;

/**
 * This bean encodes the detailed data about an eric reponse error, usually read
 * from one of the error response tables. These detail objects are usually
 * plugged in to an EricResponseErrorBean which layers a little bit more logic
 * on top of the detail.
 * 
 * @author douglas
 * @since Nov 26, 2005
 */
public class ERErrorDetail {

    protected String code = "";

    /**
     * This may be null, in which case the error type is derived from the error
     * code:
     * 
     * 5012, 5016, 6010 == Schema Validation Error anything else == Business
     * Rule Error
     */
    protected EricErrorType errorType = null;

    protected String locator = "";

    protected String messageText = "";

    protected String brCode = "BR-Unknown";

    protected QualityStage stage = QualityStage.QS2;

    protected ErrorProcessor errorProcessor;

    public String getCode() {
        return code;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public EricErrorType getErrorType() {
        if (errorType != null) {
            return errorType;
        }

        final String code = getCode();
        if (code.equals("5012") || code.equals("5016") || code.equals("6010")) {
            return EricErrorType.SCHEMA_VALIDATION;
        }

        return EricErrorType.BUSINESS_RULE;
    }

    public void setErrorType(final EricErrorType errorType) {
        this.errorType = errorType;
    }

    public String getLocator() {
        return locator;
    }

    public void setLocator(final String locator) {
        this.locator = locator;
    }

    public String getMessageText() {
        return messageText;
    }

    public void setMessageText(final String messageText) {
        this.messageText = messageText;
    }

    public void setBRCode(final String brCode) {
        this.brCode = brCode;
    }

    public String getBRCode() {
        return this.brCode;
    }

    /**
     * @return Returns the stage (QS2/QS3).
     */
    public QualityStage getStage() {
        return stage;
    }

    /**
     * @param stage
     *            The stage to set.
     */
    public void setStage(final QualityStage stage) {
        this.stage = stage;
    }

    @Override
    public String toString() {
        final StringBuffer buffer = new StringBuffer();
        buffer.append("code=");
        buffer.append(getCode());
        buffer.append(", locator=");
        buffer.append(getLocator());
        buffer.append(", messageText=");
        buffer.append(getMessageText());
        buffer.append(", brCode=");
        buffer.append(getBRCode());
        buffer.append(", stage=");
        buffer.append(getStage());
        return buffer.toString();
    }

    public ErrorProcessor getErrorProcessor() {
        return errorProcessor;
    }

    public void setErrorProcessor(final ErrorProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
    }
}
