/*
 * Created on Nov 15, 2005
 *
 * $Id: EricErrorType.java,v 1.1 2005/11/26 13:46:04 dec Exp $
 */
package ericResponse.output.error;

/**
 * A simple enumeration of the values which can go in the &lt;Type&gt; element
 * of the eric response XML for an error.
 * 
 * $Id: EricErrorType.java,v 1.1 2005/11/26 13:46:04 dec Exp $
 */
public class EricErrorType {

    public static final String FATAL_STRING = "fatal";

    public static final String BUSINESS_RULE_STRING = "business-rule";

    public static final String SCHEMA_VALIDATION_STRING = "schema-validation";

    public final static EricErrorType FATAL = new EricErrorType(FATAL_STRING);

    public final static EricErrorType BUSINESS_RULE = new EricErrorType(BUSINESS_RULE_STRING);

    public final static EricErrorType SCHEMA_VALIDATION = new EricErrorType(SCHEMA_VALIDATION_STRING);

    public static final EricErrorType fromString(final String string) {
        if (FATAL_STRING.equals(string))
            return FATAL;
        else if (BUSINESS_RULE_STRING.equals(string))
            return BUSINESS_RULE;
        else if (SCHEMA_VALIDATION_STRING.equals(string))
            return SCHEMA_VALIDATION;
        throw new IllegalArgumentException("unknown eric error type: '" + string + "'");
    }

    private final String name;

    private EricErrorType(final String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public boolean equals(final Object object) {
        return object != null && object instanceof EricErrorType && object.toString().equals(name);
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

}
