/*
 * Created on Nov 3, 2005
 * 
 * $Id: EricResponseError.java,v 1.7 2006/06/14 10:00:05 dec Exp $
 */
package ericResponse.output.error;

import hmrc.bizrules.QualityStage;

import java.util.List;

import processingError.ErrorProcessor;

public interface EricResponseError {

    /**
     * 
     * @return the error type code as defined in the eric error response
     *         document (e.g. 5012, 7140, etc.) This code ends up in the Number
     *         element of the response XML.
     */
    String getCode();

    String getLocator();

    /**
     * 
     * @return the text will be output in the Message element of the response
     *         XML
     */
    String getMessageText();

    /**
     * 
     * @return either 'business-rule' or 'schema-error'. This will end up in the
     *         Type element of the XML response.
     */
    EricErrorType getErrorType();

    /**
     * information about the incorrect field that caused the error
     */
    Object getExtraInfo();

    /**
     * @return the object which represents any underlying error which caused
     *         this Eric reponse error to be generated. It is an Object to avoid
     *         tying this interface to any particular underlying mechanism.
     * @since 25-Nov-2005
     */
    Object getUnderlyingError();

    /**
     * gets the BR Code - not really consitent enough to be definitively useful.
     */
    String getBRCode();

    /**
     * @return Returns the quality standard stage to which the failed rule
     *         applies (QS2/QS3).
     */
    QualityStage getStage();

    ErrorProcessor getErrorProcessor();

    /**
     * This method should return any extra detail messages associated with this
     * error (as a list of Strings). These will be included as comments in the
     * XML response document for this error, if this option is enabled. This
     * method may return null or an empty list if no message detail can be
     * generated.
     */
    List<String> generateExtraDetailMessages();
}
