package ericResponse.output.error;

import processingError.ProcessingError;
import ericResponse.output.EricResponseErrorMapper;
import ericResponse.output.EricResponsePostValidationDelegate;
import ericResponse.output.translator.TranslationContext;
import ericResponse.output.translator.mapper.ErrorMapper;

/**
 * This interface may be implemented when a HMRC validator implementation needs
 * control over the creation of the {@code EricResponseError} objects during the
 * mapping stage. The response generator framework will delegate to this
 * interface when creating {@link EricResponseError}s that result from errors
 * mapped via registered {@link ErrorMapper}s.
 * <p>
 * To provide an implementation, override the
 * {@link EricResponsePostValidationDelegate#createEricResponseErrorFactory()}
 * method on your validator's post validation delegate class to return a new
 * instance of your EricResponseErrorFactory implementation. The validator
 * framework will then ensure your factory is passed to the
 * {@link EricResponseErrorMapper} class when it is constructed.
 * <p>
 * When no custom factory is provided, the framework will use a default factory
 * that just creates instances of {@link EricResponseErrorBean}.
 * <p>
 * Refer to the PAYE validator implementation for an example of a custom factory
 * implementation.
 * 
 * @see EricResponsePostValidationDelegate
 * @see EricResponseErrorMapper
 * 
 * @author jesse
 */
public interface EricResponseErrorFactory {

    /**
     * Implementors of this method should create and return an EricResponseError
     * instance appropriate for their validator implementation.
     * <p>
     * The default implementation of this factory used by the framework
     * implements this method as:
     * <p>
     * 
     * <pre>
     * return new EricResponseErrorBean(detail, pe, context, mapper);
     * </pre>
     * 
     * @param detail
     *            The error detail object produced by the ErrorMapper that
     *            mapped the error.
     * @param pe
     *            The processing error object that was mapped.
     * @param context
     *            The error translation context object that was supplied by the
     *            validator implementation.
     * @param mapper
     *            The error mapper that mapped the error.
     * 
     * @return A suitable EricResponseError instance for the mapped error.
     */
    EricResponseError createEricResponseError(ERErrorDetail detail, ProcessingError pe, TranslationContext context,
            ErrorMapper mapper);
}
