/*
 * Created on 13-Dec-2005
 * 
 * $Id: ErrorXmlUtils.java,v 1.2 2006/03/08 17:16:24 dec Exp $
 */
package ericResponse.output.error;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

/**
 * A utility class for handling the ErrorResponse xml
 */
public final class ErrorXmlUtils {

    public static final String LINE_TERMINATOR = System.getProperty("line.separator");

    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private ErrorXmlUtils() {
        // none
    }

    @SuppressWarnings("unchecked")
    public static Element[] getElements(final Document document, final String xPath) throws JDOMException {

        final XPath xpath = XPath.newInstance(xPath);

        final Namespace govNs = Namespace.getNamespace("gov", "http://www.govtalk.gov.uk/CM/envelope");
        final Namespace errNs = Namespace.getNamespace("resp", "http://www.govtalk.gov.uk/CM/errorresponse");

        xpath.addNamespace(govNs);
        xpath.addNamespace(errNs);

        final List<Element> list = xpath.selectNodes(document);
        final Element[] result = new Element[list.size()];

        list.toArray(result);
        return result;

    }

    public static Element getElement(final Document document, final String xPath) throws JDOMException {

        final XPath xpath = XPath.newInstance(xPath);

        final Namespace govNs = Namespace.getNamespace("gov", "http://www.govtalk.gov.uk/CM/envelope");
        final Namespace errNs = Namespace.getNamespace("resp", "http://www.govtalk.gov.uk/CM/errorresponse");

        xpath.addNamespace(govNs);
        xpath.addNamespace(errNs);

        return (Element) xpath.selectSingleNode(document);

    }

    public static void writeToStream(final OutputStream outputStream, final String string) throws IOException {
        outputStream.write(string.getBytes());
    }

    public static void writeLineTerminatorToStream(final OutputStream outputStream) throws IOException {
        outputStream.write(LINE_TERMINATOR.getBytes());
    }

    public static final String readFile(final File file) {

        final StringBuffer buffer = new StringBuffer();
        String result;
        try {
            final Reader reader = new BufferedReader(new FileReader(file), 8192);
            final char[] buf = new char[8192];
            int count;
            while ((count = reader.read(buf)) > -1) {
                buffer.append(buf, 0, count);
            }
            reader.close();
            result = buffer.toString();
        } catch (final IOException e) {
            e.printStackTrace();
            result = null;
        }

        return result;
    }

    /**
     * Provides a quick GUESS at the period end date. If period end date is not
     * found in the first 2k of the document it gives up and returns null. This
     * method should NOT be relied on, this method was written for test tools.
     * Everything that is read from the reader is pushed back on the the reader.
     * Its best to call this method with something like a buffered reader.
     */
    public static Date getPeriodEnd(final Reader reader) {

        Date result = null;

        try {
            final char[] buffer = new char[4000];

            reader.mark(buffer.length);
            final int len = reader.read(buffer, 0, buffer.length);
            reader.reset();

            if (len != -1) {

                final String xml = new String(buffer);
                int start = xml.indexOf("<PeriodEnd>");

                if (start != -1) {
                    start += "<PeriodEnd>".length();

                    final int end = xml.indexOf("</PeriodEnd>");

                    if (end != -1) {
                        final String dateStr = xml.substring(start, end);
                        try {
                            result = SIMPLE_DATE_FORMAT.parse(dateStr);
                        } catch (final ParseException e) {
                            // e.printStackTrace();
                        }
                    }
                }
            }
        } catch (final IOException e1) {
            e1.printStackTrace();
        }

        return result;
    }
}
