package ericResponse.output.filters;

import java.util.Iterator;
import java.util.List;

import xmldoc.DocumentError;
import bizrules.BusinessRuleError;
import ericResponse.output.EricErrorFilter;
import ericResponse.output.error.EricResponseError;

/**
 * This filter will check to see if any DocumentErrors are present in the list.
 * If so, it will remove any non-Document errors.
 * 
 * @author doug
 * 
 */
public class FilterBizErrorsIfDocErrors implements EricErrorFilter {

    public List<EricResponseError> filterErrors(final List<EricResponseError> ericErrors) {
        boolean hasSchemaErrors = false;
        for (final Iterator<EricResponseError> iter = ericErrors.iterator(); !hasSchemaErrors && iter.hasNext();) {
            final EricResponseError error = (EricResponseError) iter.next();
            hasSchemaErrors = (error.getUnderlyingError() instanceof DocumentError);
        }
        if (hasSchemaErrors) {
            for (final Iterator<EricResponseError> iter = ericErrors.iterator(); iter.hasNext();) {
                final EricResponseError error = (EricResponseError) iter.next();
                if (error.getUnderlyingError() instanceof BusinessRuleError) {
                    // remove errors in-place
                    iter.remove();
                }
            }
        }
        return ericErrors;
    }
}