/**
 * $Id: $
 */
package ericResponse.output.translator;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.xml.sax.SAXParseException;

import processingError.ErrorProcessor;
import processingError.ProcessingError;
import xmldoc.DocumentError;
import ericResponse.output.error.EricResponseError;

/**
 * @author Doug Clinton
 * 
 */
public abstract class AbstractErrorTranslator implements EricErrorTranslator {

    protected abstract Logger getLogger();

    protected void dumpErrorChain(final ProcessingError pe) {
        if (getLogger().isLoggable(Level.INFO)) {
            ErrorProcessor errorProcessor = pe.getErrorProcessor();
            ProcessingError chainedError = pe;

            while (errorProcessor != null) {
                final String output = "generated by processor " + errorProcessor.getName();

                if (chainedError.getChainedError() != null) {
                    chainedError = chainedError.getChainedError();
                    getLogger().info(output + " from error " + chainedError.getRuleName() + "." + chainedError.getSubCode() + "'.");
                    errorProcessor = chainedError.getErrorProcessor();
                } else {
                    getLogger().info(output);
                    errorProcessor = null;
                    if (chainedError instanceof DocumentError) {
                        final SAXParseException spe = (SAXParseException) chainedError.getOriginalError();
                        getLogger().info("... from " + spe);
                    }
                }
            }
        }
    }

    protected void dumpErrorChain(final EricResponseError response) {
        if (getLogger().isLoggable(Level.INFO)) {
            getLogger().info("EricResponseError " + response + " created");
            final ErrorProcessor errorProcessor = response.getErrorProcessor();
            String output = "generated ";
            if (errorProcessor != null) {
                output = "generated by processor " + errorProcessor.getName();
            }
            final ProcessingError pe = (ProcessingError) response.getUnderlyingError();
            if (pe != null) {
                getLogger().info(output + " from " + pe);
                dumpErrorChain(pe);
            } else {
                getLogger().info(output);
            }
        }
    }
}
