/*
 * Created on 02-Jan-2006
 *
 * $Id$
 */
package ericResponse.output.translator;

import java.util.logging.Level;
import java.util.logging.Logger;

import processingError.ProcessingError;
import xmldoc.DocumentError;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.error.EricResponseErrorBean;

/**
 * Catch any errors which were not trapped by the other generic mappers.
 * 
 */
public class CatchAllTranslator extends AbstractErrorTranslator {
    private static final Logger logger = LoggerFactory.getLogger("ericresponse.translation.catchallmapper");

    private static final boolean ENABLED = true;

    public boolean isApplicable(final ProcessingError pe, final TranslationContext context) {
        if (!pe.getSubCode().equals(DocumentError.SUPPRESS)) {
            if (logger.isLoggable(Level.INFO))
                logger.info("Catch All: " + String.valueOf(context) + ": " + pe.getRuleName() + "." + pe.getSubCode());
            return ENABLED;
        }
        return false;
    }

    public ERErrorDetail mapProcessingError(final ProcessingError pe) {
        final ERErrorDetail detail = new ERErrorDetail();
        detail.setMessageText("Uncaught");
        detail.setLocator(pe.getRuleName() + "." + pe.getSubCode());
        detail.setCode("9999");
        return detail;
    }

    public EricResponseError translateError(final ProcessingError pe, final TranslationContext context) {
        if (isApplicable(pe, context)) {
            final ERErrorDetail details = mapProcessingError(pe);
            final EricResponseErrorBean ere = new EricResponseErrorBean(details, pe, context);
            dumpErrorChain(ere);
            return ere;
        } else {
            return null;
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
