package ericResponse.output.translator;

import ericResponse.output.EricResponsePostValidationDelegate;
import ericResponse.output.translator.mapper.ErrorMapper;

/**
 * This interface marks an object as a error translation context implementation.
 * Currently this interface does not specify an API, it is just a marker. This
 * could change in the future if it made sense to do so.
 * <p>
 * An error translation context may be defined by a given validator
 * implementation. It will then be passed to the
 * {@link ErrorMapper#mapError(TranslationContext, String, String)} method
 * during mapping.
 * <p>
 * Mapper implementations are then free to use this extra information to perform
 * their mapping tasks, ie. down-cast as appropriate and use to carry out the
 * mapping.
 * <p>
 * To provide an implementation, override the
 * {@link EricResponsePostValidationDelegate#createTranslationContext()} method
 * on your validator's post validation delegate class to return a new instance
 * of your TranslationContext implementation.
 * 
 * @see EricResponsePostValidationDelegate
 * @see ErrorMapper
 * 
 * @author jesse
 */
public interface TranslationContext {

    // this is just a marker for now, but it could be used to house relevant API
    // in the future if it makes sense to do so
}
