package ericResponse.output.translator.genericerror;

import java.util.logging.Logger;

import processingError.ProcessingError;
import xmldoc.DocumentError;
import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.error.EricResponseErrorBean;
import ericResponse.output.translator.TranslationContext;

public class AbstractGenericErrorTranslator {

    protected static final Logger logger = Logger.getLogger("paye.parser.setup");

    public AbstractGenericErrorTranslator() {
    }

    protected EricResponseError translateError(final ProcessingError pe, final TranslationContext context,
            final GenericErrorMapper mapper) {
        EricResponseError result = null;
        if (pe.getSubCode() != DocumentError.SUPPRESS && mapper.isApplicable(pe)) {
            final ERErrorDetail details = mapper.mapProcessingError(pe);
            result = new EricResponseErrorBean(details, pe, context);
        }
        return result;
    }
}
