/*
 * Created on Nov 15, 2005
 * 
 * $Id: GenericErrorTranslator.java,v 1.8 2006/08/10 15:19:11 dec Exp $
 */
package ericResponse.output.translator.genericerror;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import processingError.ProcessingError;

import com.gsl.util.classlookup.CachingClassCollector;
import com.gsl.util.classlookup.ClassNameCollector;
import com.gsl.util.classlookup.CompositeInterfaceCollector;
import com.gsl.util.classlookup.InterfaceInstanceCollector;

import ericResponse.output.EricResponseParams;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.translator.EricErrorTranslator;
import ericResponse.output.translator.TranslationContext;

/**
 * The GenericErrorTranslator uses a list of EricDetailFactory objects to try
 * and translate the error. It will look for the first factory which applies to
 * the type of the error and use that factory to generate an ERErrorDetail
 * object. It will then create an EricResponseError with those details.
 * 
 * It would be far preferable if each of the factories was actually an
 * implementation of the EricErrorTranslator interface which would simply make
 * this another Composite pattern implementation of that interface. Creating a
 * whole different protocol for the generic mappers adds unnecessary complexity.
 */
public class RegistryBasedGenericErrorTranslator extends AbstractGenericErrorTranslator implements EricErrorTranslator {

    final List<GenericErrorMapper> genericMappers = new ArrayList<GenericErrorMapper>();

    @SuppressWarnings("unchecked")
    public RegistryBasedGenericErrorTranslator(final EricResponseParams params, final String basePackageName) {
        final Class<GenericErrorMapper> interfaceToCollect = GenericErrorMapper.class;
        ClassNameCollector baseCollector;

        if (params.getForceDynamicClassCollection()) {
            baseCollector = new InterfaceInstanceCollector(basePackageName, interfaceToCollect);
        } else {
            baseCollector = new CompositeInterfaceCollector(basePackageName, interfaceToCollect);
        }

        final ClassNameCollector collector = new CachingClassCollector(baseCollector);
        final Collection<String> genericMapperClassNames = collector.collectClassNames();

        for (final Object element : genericMapperClassNames) {
            final String className = (String) element;
            try {
                final Class<GenericErrorMapper> mapperClass = (Class<GenericErrorMapper>) Class.forName(className);
                final GenericErrorMapper mapper = mapperClass.newInstance();
                genericMappers.add(mapper);
            } catch (final InstantiationException e) {
                logger.warning("Could not instantiate rule class " + className);
            } catch (final IllegalAccessException e) {
                logger.warning("Could not access rule class " + className);
            } catch (final ClassNotFoundException e) {
                logger.warning("Could not find rule class " + className);
            }
        }
    }

    public EricResponseError translateError(final ProcessingError pe, final TranslationContext context) {
        EricResponseError result = null;
        for (final Iterator<GenericErrorMapper> iter = genericMappers.iterator(); (result == null) && iter.hasNext();) {
            final GenericErrorMapper mapper = iter.next();
            result = translateError(pe, context, mapper);
        }
        return result;
    }
}
