package ericResponse.output.translator.mapper;

import hmrc.bizrules.HMRCBusinessRuleError;
import hmrc.bizrules.QualityStage;

import java.util.logging.Logger;

import org.xml.sax.SAXParseException;

import processingError.ProcessingError;
import xmldoc.DocumentError;
import bizrules.BusinessRuleError;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.error.EricResponseErrorFactory;
import ericResponse.output.error.EricResponseErrors;
import ericResponse.output.translator.AbstractErrorTranslator;
import ericResponse.output.translator.TranslationContext;

public abstract class AbstractMapperErrorTranslator extends AbstractErrorTranslator {

    private static final Logger logger = LoggerFactory.getLogger("ericresponse.translation.mapper");

    private static final String XMLERROR = "<xmlerror>";

    private final EricResponseErrorFactory ereFactory;

    protected AbstractMapperErrorTranslator(final EricResponseErrorFactory ereFactory) {
        this.ereFactory = ereFactory;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected EricResponseError mapError(final ErrorMapper mapper, final ProcessingError pe, final TranslationContext context) {
        EricResponseError response = null;

        final String ruleName = pe.getRuleName();
        final String subCode = pe.getSubCode();

        final ERErrorDetail detail = mapper.mapError(context, ruleName, subCode);

        if (detail != null) {
            if (detail.getMessageText().equals(XMLERROR)) {
                ProcessingError temp = pe;
                while (temp instanceof BusinessRuleError) {
                    temp = temp.getChainedError();
                }
                if (temp instanceof DocumentError) {
                    final Object o = temp.getOriginalError();
                    if (o instanceof SAXParseException) {
                        final SAXParseException spe = (SAXParseException) o;
                        detail.setMessageText(spe.getMessage());
                    }
                }
            }

            if (pe instanceof HMRCBusinessRuleError) {
                final QualityStage qualityStage = ((HMRCBusinessRuleError) pe).getQualityStage();

                // assert !(qualityStage == QualityStage.QS2 &&
                // detail.getTolerance() == Tolerance.CASH) : "QS2 error
                // should not have Cash tolerance. " + mapper.getName()
                // + ": " + pe;

                detail.setStage(qualityStage);
            }

            detail.setErrorProcessor(mapper);

            response = createERE(detail, pe, context, mapper);

            if (response != DO_NOT_MAP) {
                dumpErrorChain(response);
            }
        }

        return response;
    }

    private EricResponseError createERE(final ERErrorDetail detail, final ProcessingError pe, final TranslationContext context,
            final ErrorMapper mapper) {
        if (detail != EricResponseErrors.DO_NOT_MAP_DETAIL) {
            return ereFactory.createEricResponseError(detail, pe, context, mapper);
        } else {
            return DO_NOT_MAP;
        }
    }
}
