package ericResponse.output.translator.mapper;

import processingError.ProcessingError;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.error.EricResponseErrorFactory;
import ericResponse.output.translator.TranslationContext;

public class SingleMapperErrorTranslator extends AbstractMapperErrorTranslator {

    private final ErrorMapper mapper;

    public SingleMapperErrorTranslator(final ErrorMapper mapper, final EricResponseErrorFactory ereFactory) {
        super(ereFactory);
        this.mapper = mapper;
    }

    public EricResponseError translateError(final ProcessingError pe, final TranslationContext context) {
        EricResponseError response = null;

        final String ruleName = pe.getRuleName();
        final String[] ruleNames = mapper.getRuleNames();
        for (final String element : ruleNames) {
            if (ruleName.equals(element)) {
                response = mapError(mapper, pe, context);
                break;
            }
        }

        return response;
    }
}
