/* ___COPYRIGHT_GOES_HERE___ */
package ericResponse.output.translator.tables.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;

import ericResponse.output.JDomOutputterUtil;

/**
 * conversion ErrorXXX.xml of year 0405 to ErrorXXX.xml year 0506
 */
public class ConvertIRDataToSchemaValid {

    private static final XmlConverter XML_CONVERTER = new XmlConverter();

    public static void main(final String args[]) {

        final String dir;

        if (args.length == 0) {
            dir = "K:\\positives";
        } else {
            dir = args[0];
        }
        String sourceDirName;
        if (args.length >= 1) {
            sourceDirName = args[1];
        } else {
            sourceDirName = "../testdata/data/tolerances/yr-0506/Lot1-Testcases/Testcases/Positives";
        }

        final File sourceDir = new File(sourceDirName);

        new ConvertIRDataToSchemaValid().convert(sourceDir, new File(dir));
    }

    public void convert(final File sourceDir, final File targetDir) {

        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };

        final File[] filesInDir = sourceDir.listFiles(filter);

        for (int i = 0; i < filesInDir.length; ++i) {

            final File file = filesInDir[i];
            final File source04050File = new File(sourceDir.getPath() + File.separatorChar + file.getName());

            final String xml = XML_CONVERTER.readFile(source04050File);
            final SAXBuilder builder = new SAXBuilder();
            Document document;
            try {
                document = builder.build(new StringReader(xml));

                {
                    // hard code the CorrelationID
                    final String p14XPath = "/ir:GovTalkMessage/ir:Header/ir:MessageDetails/ir:CorrelationID";
                    XML_CONVERTER.setElementText(p14XPath, "1234", document);
                }

                {
                    // remove the Name
                    final String totalNICholidayClaimedXPath = "/ir:GovTalkMessage/ir:GovTalkDetails/ir:ChannelRouting/ir:Channel/ir:Name";
                    XML_CONVERTER.removeElement(document, totalNICholidayClaimedXPath);
                }

                final Writer output = new FileWriter(targetDir.getPath() + File.separatorChar + file.getName());
                JDomOutputterUtil.writeToOutput(output, document, Format.getPrettyFormat());
                output.close();

            } catch (final JDOMException e) {
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        }

    }

}