/* ___COPYRIGHT_GOES_HERE___ */
package ericResponse.output.translator.tables.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Logger;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.JDomOutputterUtil;

/**
 * conversion ErrorXXX.xml of year 0405 to ErrorXXX.xml year 0506
 */
public class Converter0405to0506 {

    private final static String INFO = "Converst an 04-50 request message to 0506.";

    private static final Logger LOGGER = LoggerFactory.getLogger("ericresponse");

    private static final XmlConverter XML_CONVERTER = new XmlConverter();

    public static void main(final String args[]) {

        final String dir;

        if (args.length == 0) {
            LOGGER.info("[<target file>] [<source directory>]\n" + INFO);
            dir = "K:\\ProcessingErrors0506";
        } else {
            dir = args[0];
        }

        String sourceDirName;
        if (args.length == 0) {
            sourceDirName = "c:\\temp\\temp";
        } else {
            sourceDirName = args[1];
        }

        final File sourceDir = new File(sourceDirName);

        new Converter0405to0506().convert(sourceDir, new File(dir));
    }

    public void convert(final File sourceDir, final File targetDir) {

        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };

        final File[] filesInDir = sourceDir.listFiles(filter);

        for (int i = 0; i < filesInDir.length; ++i) {

            final File file = filesInDir[i];

            final File source04050File = new File(sourceDir.getPath() + File.separatorChar + file.getName());

            try {

                final String xml = XML_CONVERTER.readFile(source04050File);
                final SAXBuilder builder = new SAXBuilder();
                final Document document = builder.build(new StringReader(xml));

                {
                    // hard code the NINO P14
                    final String p14XPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14";
                    hardCodeNino(p14XPath, document);
                }
                {
                    // hard code the NINO P14Amended
                    final String p14AmendedXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14Amended";
                    hardCodeNino(p14AmendedXPath, document);
                }
                {
                    // remove NICholiday P35
                    final String nicHolidayXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P35/eoy:Summary/eoy:NIC/eoy:NICholiday";
                    XML_CONVERTER.removeElement(document, nicHolidayXPath);
                }
                {
                    // remove NICholiday P35Amended
                    final String nicHolidayXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P35Amended/eoy:Summary/eoy:NIC/eoy:NICholiday";
                    XML_CONVERTER.removeElement(document, nicHolidayXPath);
                }
                {
                    // remove EmployerAddress P35
                    final String employerAddressXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P35/eoy:EmployerDetails/eoy:EmployerAddress";
                    XML_CONVERTER.removeElement(document, employerAddressXPath);
                }
                {
                    // remove EmployerAddress P35Amended
                    final String employerAddressXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P35Amended/eoy:EmployerDetails/eoy:EmployerAddress";
                    XML_CONVERTER.removeElement(document, employerAddressXPath);
                }

                {
                    // remove TotalNICholidayClaimed
                    final String totalNICholidayClaimedXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:PartTotals/eoy:TotalNICholidayClaimed";
                    XML_CONVERTER.removeElement(document, totalNICholidayClaimedXPath);
                }

                {
                    // add incentivePayment
                    final String totalPaidXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPaid";
                    final Element totalPaid = XML_CONVERTER.getElement(document, totalPaidXPath);

                    if (totalPaid != null) {
                        final Element parent = (Element) totalPaid.getParent();
                        final int index = parent.indexOf(totalPaid);
                        {
                            // add IncentivePayment
                            final Element incentivePayment = new Element("IncentivePayment");
                            incentivePayment.addContent("0.00");
                            incentivePayment.setNamespace(parent.getNamespace());
                            parent.addContent(index + 1, incentivePayment);
                        }
                    }
                }
                {
                    // set the periodEnd to 0506
                    final String periodEndXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:IRheader/eoy:PeriodEnd";
                    XML_CONVERTER.setElementText(periodEndXPath, "2006-04-05", document);
                }

                final Writer output = new FileWriter(targetDir.getPath() + File.separatorChar + file.getName());
                JDomOutputterUtil.writeToOutput(output, document, Format.getPrettyFormat());
                output.close();

            } catch (final FileNotFoundException e) {
                e.printStackTrace();

            } catch (final JDOMException e) {
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * hard codes the nino to NY200481D
     */
    private void hardCodeNino(final String p14XPath, final Document document) throws JDOMException {
        final Element[] elements = XML_CONVERTER.getElements(document, p14XPath);
        for (final Element element : elements) {
            final Element nino = element.getChild("NINO", element.getNamespace());
            if (nino != null) {
                XML_CONVERTER.setElementText(nino, "NY200481D");
            }
        }

    }

}