/* ___COPYRIGHT_GOES_HERE___ */
package ericResponse.output.translator.tables.tools;

import java.io.*;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.logging.Logger;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.JDomOutputterUtil;

/**
 * conversion ErrorXXX.xml of year 0506 to ErrorXXX.xml year 0607
 */
public class Converter0506to0607 {

    private final static String INFO = "Converts an 0506 request message to 0607.";

    private static final Logger LOGGER = LoggerFactory.getLogger("ericresponse");

    private static final XmlConverter XML_CONVERTER = new XmlConverter();

    private static final String EOY = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn";

    public static void main(final String args[]) {

        final String targetDir;

        if (args.length == 0) {
            LOGGER.info("[<target directory>] [<source directory>]\n" + INFO);
            targetDir = "c:\\temp";
        } else {
            targetDir = args[0];
        }

        String sourceDirName;
        if (args.length == 0) {
            sourceDirName = "D:\\development\\ir\\testdata\\data\\ProcessingErrors\\ProcessingErrors0506";
        } else {
            sourceDirName = args[1];
        }

        final File sourceDir = new File(sourceDirName);

        new Converter0506to0607().convert(sourceDir, new File(targetDir));
    }

    public void convert(final File sourceDir, final File targetDir) {

        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };

        final File[] filesInDir = sourceDir.listFiles(filter);

        for (int i = 0; i < filesInDir.length; ++i) {

            final File file = filesInDir[i];

            final File source04050File = new File(sourceDir.getPath() + File.separatorChar + file.getName());

            try {

                final String xml = XML_CONVERTER.readFile(source04050File);
                final SAXBuilder builder = new SAXBuilder();
                final Document document = builder.build(new StringReader(xml));

                final String returnTypeType = XML_CONVERTER.getElementText(document, EOY + "/eoy:ReturnType");

                {
                    // remove Subcontractor
                    final String subContractorXPath = EOY + "/eoy:P35/eoy:Summary/eoy:PAYE/eoy:SubcontractorTax";
                    XML_CONVERTER.removeElement(document, subContractorXPath);
                }

                {
                    // remove Subcontractor
                    final String subContractorXPath = EOY + "/eoy:P35Amended/eoy:Summary/eoy:PAYE/eoy:SubcontractorTax";
                    XML_CONVERTER.removeElement(document, subContractorXPath);
                }

                // add CombinedLessStatutoryRecovered
                if ("Amended".equalsIgnoreCase(returnTypeType)) {
                    convert(document, "P35Amended");
                } else if ("Original".equalsIgnoreCase(returnTypeType)) {
                    convert(document, "P35");
                } else {
                    // throw new AssertionError("Unknown submission type, should
                    // be origional or amended");
                }

                {
                    // remove Subcontractor
                    final String xPath = EOY + "/eoy:P35/eoy:Summary/eoy:PAYE/eoy:SubcontractorTax";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCreditFunding - original
                    final String xPath = EOY + "/eoy:P35/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCreditFunding";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCreditFunding - Amended
                    final String xPath = EOY + "/eoy:P35Amended/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCreditFunding";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCredit - original
                    final String xPath = EOY + "/eoy:P35/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCredit";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCredit - Amended
                    final String xPath = EOY + "/eoy:P35Amended/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCredit";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove NetTaxCredits - original
                    final String xPath = EOY + "/eoy:P35/eoy:Summary/eoy:CombinedAmounts/eoy:NetTaxCredits";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove NetTaxCredits - Amended
                    final String xPath = EOY + "/eoy:P35Amended/eoy:Summary/eoy:CombinedAmounts/eoy:NetTaxCredits";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove NetDeductions - original
                    final String xPath = EOY + "/eoy:P35/eoy:Summary/eoy:CombinedAmounts/eoy:NetDeductions";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove NetDeductions - Amended
                    final String xPath = EOY + "/eoy:P35Amended/eoy:Summary/eoy:CombinedAmounts/eoy:NetDeductions";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCredit - in p14
                    final String xPath = EOY + "/eoy:P14/eoy:PayAndTax/eoy:ThisEmp/eoy:TaxCredit";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCredit - in p14
                    final String xPath = EOY + "/eoy:P14Amended/eoy:PayAndTax/eoy:ThisEmp/eoy:TaxCredit";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCredit - in p14
                    final String xPath = EOY + "/eoy:PartTotals/eoy:TotalTaxCredits";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // remove TaxCredit - amended - in p14
                    final String xPath = EOY + "/eoy:PartTotalsAmended/eoy:TotalTaxCredits";
                    XML_CONVERTER.removeElement(document, xPath);
                }

                {
                    // set the periodEnd to 0607
                    final String xPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:IRheader/eoy:PeriodEnd";
                    XML_CONVERTER.setElementText(xPath, "2007-04-05", document);
                }

                // OutputStream fileOuputStream = new
                // FileOutputStream(targetDir.getPath() + File.separatorChar +
                // file.getName());
                final OutputStream outputStream = new ByteArrayOutputStream();
                final Writer output = new OutputStreamWriter(outputStream);
                JDomOutputterUtil.writeToOutput(output, document, Format.getPrettyFormat());

                {
                    String xmlDocument = outputStream.toString();
                    xmlDocument = xmlDocument.replaceAll("http://www.govtalk.gov.uk/taxation/EOY",
                            "http://www.govtalk.gov.uk/taxation/EOY/06-07/1");
                    final OutputStream fileOuputStream = new FileOutputStream(targetDir.getPath() + File.separatorChar
                            + file.getName());
                    fileOuputStream.write(xmlDocument.getBytes());
                    fileOuputStream.close();
                }
                outputStream.close();

            } catch (final FileNotFoundException e) {
                e.printStackTrace();

            } catch (final JDOMException e) {
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void convert(final Document document, final String p35) throws JDOMException {
        {
            // /GovTalkMessage/Body/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan

            final String totalNicTaxAndStudentLoanStr = XML_CONVERTER.getElementText(document, EOY + "/eoy:" + p35
                    + "/eoy:Summary/eoy:CombinedAmounts/eoy:TotalNICsTaxAndStudentLoan");

            if (totalNicTaxAndStudentLoanStr != null) {
                final String netStatutoryPaymentsRecoveredStr = XML_CONVERTER.getElementText(document, EOY + "/eoy:" + p35
                        + "/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered");

                String CombinedLessStatutoryRecoveredStr;

                try {
                    final BigDecimal totalNicTaxAndStudentLoan = new BigDecimal(totalNicTaxAndStudentLoanStr);
                    final BigDecimal netStatutoryPaymentsRecovered = new BigDecimal(netStatutoryPaymentsRecoveredStr);

                    final BigDecimal combinedLessStatutoryRecovered = totalNicTaxAndStudentLoan
                            .subtract(netStatutoryPaymentsRecovered);

                    final NumberFormat nf = NumberFormat.getInstance();

                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    nf.setGroupingUsed(false);
                    CombinedLessStatutoryRecoveredStr = nf.format(combinedLessStatutoryRecovered.doubleValue());
                } catch (final NumberFormatException e) {
                    CombinedLessStatutoryRecoveredStr = "0.00";
                }
                XML_CONVERTER.createElementAfterElement(document, "CombinedLessStatutoryRecovered", EOY + "/eoy:" + p35
                        + "/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered");
                XML_CONVERTER.setElementText(EOY + "/eoy:" + p35
                        + "/eoy:Summary/eoy:CombinedAmounts/eoy:CombinedLessStatutoryRecovered", CombinedLessStatutoryRecoveredStr,
                        document);
            }
        }

        {
            XML_CONVERTER.createElementAfterElement(document, "SubcontractorTax", EOY + "/eoy:" + p35
                    + "/eoy:Summary/eoy:CombinedAmounts/eoy:CombinedLessStatutoryRecovered");
            XML_CONVERTER.setElementText(EOY + "/eoy:" + p35 + "/eoy:Summary/eoy:CombinedAmounts/eoy:SubcontractorTax", "0.00",
                    document);
        }

    }
}