/* ___COPYRIGHT_GOES_HERE___ */
package ericResponse.output.translator.tables.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Logger;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.JDomOutputterUtil;

/**
 * conversion ErrorXXX.xml of year 0405 to ErrorXXX.xml year 0506
 */
public class ConverterNino {

    private final static String INFO = "";

    private static final Logger logger = LoggerFactory.getLogger("ericresponse");

    private static final XmlConverter XML_CONVERTER = new XmlConverter();

    public static void main(final String args[]) {

        final String dir;

        if (args.length == 0) {
            logger.info("[<target file>] [<source directory>]\n" + INFO);
            dir = "K:\\ProcessingErrors0405Amended";
        } else {
            dir = args[0];
        }

        String sourceDirName;
        if (args.length == 0) {
            sourceDirName = "D:\\development\\ir\\testdata\\data\\ProcessingErrors\\ProcessingErrors0405\\amended";
        } else {
            sourceDirName = args[1];
        }

        final File sourceDir = new File(sourceDirName);

        new ConverterNino().convert(sourceDir, new File(dir));
    }

    public void convert(final File sourceDir, final File targetDir) {

        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };

        final File[] filesInDir = sourceDir.listFiles(filter);

        for (int i = 0; i < filesInDir.length; ++i) {

            final File file = filesInDir[i];

            final File source04050File = new File(sourceDir.getPath() + File.separatorChar + file.getName());

            try {

                final String xml = XML_CONVERTER.readFile(source04050File);
                final SAXBuilder builder = new SAXBuilder();
                final Document document = builder.build(new StringReader(xml));

                {
                    // hard code the NINO P14
                    final String p14XPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14Amended";
                    hardCodeNino(p14XPath, document);
                }

                final Writer output = new FileWriter(targetDir.getPath() + File.separatorChar + file.getName());
                JDomOutputterUtil.writeToOutput(output, document, Format.getPrettyFormat());
                output.close();

            } catch (final FileNotFoundException e) {
                e.printStackTrace();

            } catch (final JDOMException e) {
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * hard codes the nino to NY200481D
     */
    private void hardCodeNino(final String p14XPath, final Document document) throws JDOMException {
        final Element[] elements = XML_CONVERTER.getElements(document, p14XPath);
        for (final Element element : elements) {
            final Element nino = element.getChild("NINO", element.getNamespace());
            if (nino != null) {

                if ("JB384209".equals(nino.getText())) {
                    XML_CONVERTER.setElementText(nino, "NY200481D");
                }
            }
        }

    }
}