/* ___COPYRIGHT_GOES_HERE___ */
package ericResponse.output.translator.tables.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Logger;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.JDomOutputterUtil;

/**
 * conversion origional returns to ammend returns and changes where appropriate.
 */
public class ConverterOriginalToAmended {

    private final static String INFO = "Converts original submissions to amended submissions.";

    private static final Logger logger = LoggerFactory.getLogger("ericresponse");

    private static final XmlConverter XML_CONVERTER = new XmlConverter();

    public static void main(final String args[]) {

        final String dir;

        if (args.length == 0) {
            logger.info("[<target file>] [<source directory>]\n" + INFO);
            dir = "K:\\ConvertedOriginalToAmended";
        } else {
            dir = args[0];
        }

        String sourceDirName;
        if (args.length == 0) {
            sourceDirName = "D:\\development\\ir\\testdata\\data\\ProcessingErrors\\ProcessingErrors0405";
        } else {
            sourceDirName = args[1];
        }

        final File sourceDir = new File(sourceDirName);

        new ConverterOriginalToAmended().convert(sourceDir, new File(dir));
    }

    public void convert(final File sourceDir, final File targetDir) {

        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };

        final File[] filesInDir = sourceDir.listFiles(filter);

        for (int i = 0; i < filesInDir.length; ++i) {

            final File file = filesInDir[i];

            final File source04050File = new File(sourceDir.getPath() + File.separatorChar + file.getName());

            try {

                final String xml = XML_CONVERTER.readFile(source04050File);
                final SAXBuilder builder = new SAXBuilder();
                final Document document = builder.build(new StringReader(xml));
                final Element element = XML_CONVERTER.getElement(document,
                        "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:ReturnType");

                final String getSubmissonType = element.getText();

                if ("original".equals(getSubmissonType)) {

                    logger.info("Converting and original submission :" + source04050File.getName());
                    {
                        // change the part totals to part totals ammended
                        final String partTotalsXPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:ReturnType";
                        XML_CONVERTER.setElementText(partTotalsXPath, "amended", document);
                    }

                    {
                        // change the part totals to part totals ammended
                        final String xPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:PartTotals";
                        XML_CONVERTER.setElementName(xPath, "PartTotalsAmended", document);

                        // MAKE THE DELTAS ''' HOW ... mmm
                    }

                    {
                        // changes P14's to P14Ammend's
                        final String xPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14";
                        XML_CONVERTER.setElementName(xPath, "P14Amended", document);
                    }

                    {
                        // changes P35's to P35Ammend's
                        final String xPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P35";
                        XML_CONVERTER.setElementName(xPath, "P35Amended", document);
                    }

                    {
                        // changes the submission type
                        final String xPath = "/ir:GovTalkMessage/ir:Body/eoy:IRenvelope/eoy:EndOfYearReturn/eoy:SubmissionType";
                        setSubmissionTypeToAmended(xPath, document);
                    }

                    String name = file.getName();

                    final int end = name.indexOf(".xml");
                    if (i != -1) {
                        name = name.substring(0, end) + "-amended.xml";
                    }

                    final Writer output = new FileWriter(targetDir.getPath() + File.separatorChar + name);
                    JDomOutputterUtil.writeToOutput(output, document, Format.getPrettyFormat());
                    output.close();
                } else {

                    logger.info("Skippped " + source04050File.getName() + " as it was an original submission");
                }
            } catch (final FileNotFoundException e) {
                e.printStackTrace();

            } catch (final JDOMException e) {
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * changes the submisison type to ammened NOTE : this wont changed comeplete
     * parts.
     */
    private void setSubmissionTypeToAmended(final String xPath, final Document document) throws JDOMException {
        final Element[] elements = XML_CONVERTER.getElements(document, xPath);
        for (final Element element : elements) {
            final String text = element.getText();
            if ("P35".equals(text)) {
                element.setText("P35Amended");
            } else if ("P14".equals(text)) {
                element.setText("P14Amended");
            }
        }
    }
}