/*
 * Created on 13-Dec-2005
 *
 * $Id: XmlConverter.java,v 1.6 2006/02/14 15:47:03 raustin Exp $
 */
package ericResponse.output.translator.tables.tools;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

/**
 * $Id: XmlConverter.java,v 1.6 2006/02/14 15:47:03 raustin Exp $
 */
public final class XmlConverter {

    String eoyNameSpace = "http://www.govtalk.gov.uk/taxation/EOY/06-07/1";

    public void removeElement(final Document document, final String xPath) throws JDOMException {

        final Element element = getElement(document, xPath);

        if (element != null) {
            element.detach();
        }
    }

    public void setElementText(final Element element, final String value) {
        element.removeContent();
        element.addContent(value);
    }

    /**
     * sets the name of the element at the xPath
     */
    public void setElementName(final String xPath, final String newNameOfElement, final Document document) throws JDOMException {
        final Element[] elements = getElements(document, xPath);
        for (final Element element : elements) {
            element.setName(newNameOfElement);
        }

    }

    public void setEOYNameSpace(final String namespace) {
        eoyNameSpace = namespace;
    }

    public Element getElement(final Document document, final String xPath) throws JDOMException {

        final Namespace irNs = Namespace.getNamespace("ir", "http://www.govtalk.gov.uk/CM/envelope");
        final Namespace eoyNs = Namespace.getNamespace("eoy", eoyNameSpace);

        final XPath xpath = XPath.newInstance(xPath);
        xpath.addNamespace(irNs);
        xpath.addNamespace(eoyNs);

        return (Element) xpath.selectSingleNode(document);

    }

    @SuppressWarnings("unchecked")
    public Element[] getElements(final Document document, final String xPath) throws JDOMException {

        final Namespace irNs = Namespace.getNamespace("ir", "http://www.govtalk.gov.uk/CM/envelope");
        final Namespace eoyNs = Namespace.getNamespace("eoy", eoyNameSpace);

        final XPath xpath = XPath.newInstance(xPath);
        xpath.addNamespace(irNs);
        xpath.addNamespace(eoyNs);

        final List<Element> list = xpath.selectNodes(document);
        final Element[] result = new Element[list.size()];

        list.toArray(result);
        return result;

    }

    public final String readFile(final File file) {

        String result = null;

        try {
            final FileInputStream fis = new FileInputStream(file);
            final CharArrayWriter charArrayWriter = new CharArrayWriter();

            int nextChar;
            while ((nextChar = fis.read()) != -1) {
                charArrayWriter.write(nextChar);
            }
            result = charArrayWriter.toString();
            fis.close();
        } catch (final FileNotFoundException e) {
            e.printStackTrace();

        } catch (final IOException e) {
            e.printStackTrace();

        }
        return result;

    }

    public void setElementText(final String xPath, final String value, final Document document) throws JDOMException {
        final Element element = getElement(document, xPath);
        if (element != null) {
            setElementText(element, value);
        }
    }

    public void createElementAfterElement(final Document document, final String newElementName, final String xPathOfExistingElement)
            throws JDOMException {

        final Element existingElement = getElement(document, xPathOfExistingElement);

        if (existingElement != null) {
            final Element parent = existingElement.getParentElement();
            final Element newElement = new Element(newElementName);
            newElement.setNamespace(parent.getNamespace());
            final int newIndex = parent.indexOf(existingElement) + 1;
            parent.addContent(newIndex, newElement);
        }

    }

    public String getElementText(final Document document, final String xPath) throws JDOMException {
        String result = null;
        final Element e = getElement(document, xPath);
        if (e != null) {
            result = e.getText();
        }
        return result;
    }
}
