/*
 * $Id: GatewayEnvelopeVersion.java,v 1.4 2006/05/25 17:13:06 dec Exp $
 */
package govtalk.header;

import java.util.HashMap;
import java.util.Map;

/**
 * The government gateway supports two versions of the envelope structure. The
 * version in use depends on the infrastructure being used to deliver the
 * submission. This class enumerates the two versions which we support.
 * 
 * @author Douglas Clinton
 * @since Jan 27, 2006
 * 
 */
public class GatewayEnvelopeVersion {
    private static final String GATEWAY_ENV_V1_STRING = "1.0";

    private static final String GATEWAY_ENV_V2_STRING = "2.0";

    public static final GatewayEnvelopeVersion V1 = new GatewayEnvelopeVersion(GATEWAY_ENV_V1_STRING);

    public static final GatewayEnvelopeVersion V2 = new GatewayEnvelopeVersion(GATEWAY_ENV_V2_STRING);

    private static Map<String, GatewayEnvelopeVersion> instanceMap = new HashMap<String, GatewayEnvelopeVersion>();

    private final String versionString;

    static {
        instanceMap.put(V1.toString(), V1);
        instanceMap.put(V2.toString(), V2);
    }

    /**
     * @param versionString
     *            currently support "1.0" and "2.0"
     */
    private GatewayEnvelopeVersion(final String versionString) {
        this.versionString = versionString;
    }

    @Override
    public String toString() {
        return versionString;
    }

    public static GatewayEnvelopeVersion fromString(final String versionString) {
        final GatewayEnvelopeVersion gev;
        synchronized (instanceMap) {
            gev = instanceMap.get(versionString);
            if (gev == null) {
                throw new IllegalArgumentException(versionString + " is not a supported Gateway Envelope Version");
            }
        }
        return gev;
    }

}
