/**
 * 
 */
package govtalk.header;

import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.DocumentErrorFilter;

/**
 * Filter any errors which are within GovTalkEnvelope namespace.
 * 
 */
public class GovTalkEnvelopeFilter implements DocumentErrorFilter {

    public boolean collectError(final DocumentError e) {
        boolean result = true;

        final ElementReference elementRef = e.getElementReference();
        if (elementRef != null) {
            final String elementNamespace = elementRef.getNamespaceURL();
            if (GovTalkHeaderConstants.NAMESPACE_GOVTALK_ENVELOPE.equals(elementNamespace)) {
                result = false;
            }
        }

        return result;
    }
}
