package govtalk.header;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public interface GovTalkHeaderConstants {

    public static final String NAMESPACE_GOVTALK_ENVELOPE = "http://www.govtalk.gov.uk/CM/envelope";

    public static final GovTalkHeaderDetails DEFAULT_GOV_TALK_HEADER_DETAILS = (GovTalkHeaderDetails) Proxy.newProxyInstance(
            GovTalkHeaderConstants.class.getClassLoader(), new Class[] { GovTalkHeaderDetails.class }, new InvocationHandler() {
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getReturnType() == String.class) {
                        return "Unknown";
                    }
                    return null;
                }
            });
}
