package hmrc.bizrules;

import bizrules.AbstractBusinessRule;

public abstract class AbstractHMRCBusinessRule extends AbstractBusinessRule {

    protected void raiseQS3Error(final String subCode, final Object valueInError) {
        assert getDeclaredSubcodes().contains(subCode) : "Undeclared subcode: " + subCode + " in rule class: "
                + getClass().getName();

        final HMRCBusinessRuleError businessRuleError = new HMRCBusinessRuleError(this, subCode);
        businessRuleError.setValueInError(valueInError);
        businessRuleError.setErrorProcessor(this);
        businessRuleError.setQualityStage(QualityStage.QS3);

        getErrorCollector().addError(businessRuleError);
    }

    protected void raiseQS3Error(final String subCode) {
        assert getDeclaredSubcodes().contains(subCode) : "Undeclared subcode: " + subCode + " in rule class: "
                + getClass().getName();

        final HMRCBusinessRuleError businessRuleError = new HMRCBusinessRuleError(this, subCode);
        businessRuleError.setErrorProcessor(this);
        businessRuleError.setQualityStage(QualityStage.QS3);

        getErrorCollector().addError(businessRuleError);
    }
}
