package hmrc.bizrules;

import bizrules.BusinessRule;
import bizrules.BusinessRuleError;

public class HMRCBusinessRuleError extends BusinessRuleError {

    private QualityStage qualityStage = QualityStage.QS2;

    public HMRCBusinessRuleError(final BusinessRule rule, final String subCode) {
        super(rule, subCode);
    }

    public QualityStage getQualityStage() {
        return qualityStage;
    }

    public void setQualityStage(final QualityStage qualityStage) {
        this.qualityStage = qualityStage;
    }

    @Override
    public String toString() {
        return "BusinessRule:" + rule.toString() + ", subCode:" + subCode + ", qs:" + qualityStage + ", valueInError:'"
                + valueInError + "'";
    }
}
