/**
 * $Id: $
 */
package hmrc.bizrules;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Doug Clinton
 * 
 * 
 */
public class QualityStage {
    private static final String QS2_STRING = "QS2";

    private static final String QS3_STRING = "QS3";

    public static final QualityStage QS2 = new QualityStage(QS2_STRING);

    public static final QualityStage QS3 = new QualityStage(QS3_STRING);

    private static final Map<String, QualityStage> enumMap = new HashMap<String, QualityStage>();

    static {
        enumMap.put(QS2.toString(), QS2);
        enumMap.put(QS3.toString(), QS3);
    }

    private final String processingStage;

    public QualityStage(final String processingStage) {
        this.processingStage = processingStage;
    }

    @Override
    public String toString() {
        return processingStage;
    }

    public static QualityStage fromString(final String stage) {
        return enumMap.get(stage);
    }
}
