package hmrc.validator;

import hmrc.validator.rules.IREnvelopeRule;

import java.util.*;

import xmldoc.util.ClasspathEntityResolver;
import xmldoc.util.EntityResolver;
import chris.header.ChRISEnvelopeEntityResolutionTable;
import chris.header.ChRISHeaderConstants;

import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidatorProvider;

public class ChRISEnvelopeValidatorProvider implements ValidatorProvider {

    private static final ThreadLocal<ArrayList<String>> local = new ThreadLocal<ArrayList<String>>();

    public static void addIRNamespace(final String namespace) {
        final List<String> irNamespaces = local.get();
        if (irNamespaces != null && namespace != null) {
            irNamespaces.add(namespace);
        }
    }

    public static void addIRNamespaces(final String[] namespaces) {
        addIRNamespaces(Arrays.asList(namespaces));
    }

    public static void addIRNamespaces(final Collection<String> namespaces) {
        for (final String string : namespaces) {
            addIRNamespace(string);
        }
    }

    public void init(final DocumentValidatorImplementor validator) {
        local.set(new ArrayList<String>());

    }

    public EntityResolver getEntityResolver(final ValidationParams params) {
        final String[][] entityResolutionTable = ChRISEnvelopeEntityResolutionTable.getEntityResolutionTable();
        return new ClasspathEntityResolver("ChRISEnvelope", entityResolutionTable);
    }

    public void provisionNamespace(final String namespace, final DocumentValidatorImplementor validator) {
        if (namespace.equals(ChRISHeaderConstants.NAMESPACE_CHRIS_ENVELOPE)) {
            final HMRCValidationParams params = (HMRCValidationParams) validator.getParams();

            final List<String> irNamespaces = new ArrayList<String>(local.get());
            irNamespaces.add(ChRISHeaderConstants.NAMESPACE_CHRIS_ENVELOPE);
            if (irNamespaces != null) {
                final String[] namespaces = (irNamespaces).toArray(new String[0]);
                validator.addBusinessRule(new IREnvelopeRule(namespaces, "/ChRISEnvelope/Body"));
            }

            final Set<String> rulePackages = params.getHmrcRulePackages(ChRISHeaderConstants.NAMESPACE_CHRIS_ENVELOPE);
            for (final String s : rulePackages) {
                validator.addBusinessRules(s);
            }
        }
    }

    public void destroy() {
        local.set(null);
    }
}
