package hmrc.validator;

import com.gsl.docValidator.ValidationParams;

import ericResponse.output.error.EricResponseErrorFactory;
import ericResponse.output.translator.TranslationContext;

/**
 * This interface can be used to provide more flexibility when extending
 * {@link HMRCValidationDelegate}. Usually, HMRCValidationDelegate is simply
 * subclassed and customised as required. However when two or more providers
 * need different post processing behaviour, they may each provide
 * implementations of this interface to the delegate. The delegate will then
 * 'sub-delegate' to this interface for certain aspects of its behaviour.
 * 
 * @see HMRCValidationDelegate#setDelegateHandler(DelegateHandler)
 * 
 * @author jesse
 */
public interface DelegateHandler {

    HMRCValidationResultInterface createResult(HMRCValidationDelegate delegate, ValidationParams params);

    void processResult(HMRCValidationResultInterface result, ValidationParams params);

    EricResponseErrorFactory createEricResponseErrorFactory();

    TranslationContext createTranslationContext();
}
