package hmrc.validator;

import hmrc.validator.rules.IREnvelopeRule;

import java.util.*;

import xmldoc.util.ClasspathEntityResolver;
import xmldoc.util.EntityResolver;

import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidatorProvider;

import eric.header.ERICEnvelopeEntityResolutionTable;
import eric.header.ERICHeaderConstants;

public class ERICEnvelopeValidatorProvider implements ValidatorProvider {

    private static final ThreadLocal<ArrayList<String>> local = new ThreadLocal<ArrayList<String>>();

    public static void addIRNamespace(final String namespace) {
        final List<String> irNamespaces = local.get();
        if (irNamespaces != null && namespace != null) {
            irNamespaces.add(namespace);
        }
    }

    public static void addIRNamespaces(final String[] namespaces) {
        addIRNamespaces(Arrays.asList(namespaces));
    }

    public static void addIRNamespaces(final Collection<String> namespaces) {
        for (final String string : namespaces) {
            addIRNamespace(string);
        }
    }

    public void init(final DocumentValidatorImplementor validator) {
        local.set(new ArrayList<String>());

    }

    public EntityResolver getEntityResolver(final ValidationParams params) {
        final HMRCValidationParams hmrcParams = (HMRCValidationParams) params;

        final String[][] entityResolutionTable = ERICEnvelopeEntityResolutionTable.getEntityResolutionTable(hmrcParams
                .getEricEnvelopeVersion());
        return new ClasspathEntityResolver("ERICEnvelope", entityResolutionTable);
    }

    public void provisionNamespace(final String namespace, final DocumentValidatorImplementor validator) {
        if (namespace.equals(ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE)) {
            final HMRCValidationParams params = (HMRCValidationParams) validator.getParams();

            final List<String> irNamespaces = new ArrayList<String>(local.get());
            irNamespaces.add(ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE);
            if (irNamespaces != null) {
                final String[] namespaces = (irNamespaces).toArray(new String[0]);
                validator.addBusinessRule(new IREnvelopeRule(namespaces, "/EricEnvelope/MessageBody"));
            }

            final Set<String> rulePackages = params.getHmrcRulePackages(ERICHeaderConstants.NAMESPACE_ERIC_ENVELOPE);
            for (final String s : rulePackages) {
                validator.addBusinessRules(s);
            }
        }
    }

    public void destroy() {
        local.set(null);
    }
}
