package hmrc.validator;

import ericResponse.output.GovTalkEnvelopeGenerator;
import govtalk.header.GatewayEnvelopeEntityResolutionTable;
import govtalk.header.GovTalkHeaderConstants;
import hmrc.validator.rules.IREnvelopeRule;

import java.util.*;

import xmldoc.util.ClasspathEntityResolver;
import xmldoc.util.EntityResolver;

import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.PostValidationDelegate;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidatorProvider;

public class GatewayEnvelopeValidatorProvider implements ValidatorProvider {

    private static final ThreadLocal<ArrayList<String>> local = new ThreadLocal<ArrayList<String>>();

    public static void addIRNamespace(final String namespace) {
        final List<String> irNamespaces = local.get();
        if (irNamespaces != null && namespace != null) {
            irNamespaces.add(namespace);
        }
    }

    public static void addIRNamespaces(final String[] namespaces) {
        addIRNamespaces(Arrays.asList(namespaces));
    }

    public static void addIRNamespaces(final Collection<String> namespaces) {
        for (final String string : namespaces) {
            addIRNamespace(string);
        }
    }

    public void init(final DocumentValidatorImplementor validator) {
        local.set(new ArrayList<String>());
    }

    public EntityResolver getEntityResolver(final ValidationParams params) {
        final String[][] entityResolutionTable = GatewayEnvelopeEntityResolutionTable.getEntityResolutionTable();
        return new ClasspathEntityResolver("GovTalkEnvelope", entityResolutionTable);
    }

    public void provisionNamespace(final String namespace, final DocumentValidatorImplementor validator) {
        if (namespace.equals(GovTalkHeaderConstants.NAMESPACE_GOVTALK_ENVELOPE)) {
            final HMRCValidationParams params = (HMRCValidationParams) validator.getParams();

            final List<String> irNamespaces = local.get();
            if (irNamespaces != null) {
                final String[] namespaces = (irNamespaces).toArray(new String[0]);
                validator.addBusinessRule(new IREnvelopeRule(namespaces));
            }

            final GovTalkHeaderCollector govTalkHeaderCollector = new GovTalkHeaderCollector();
            validator.addElementProcessor(govTalkHeaderCollector);

            final Set<String> rulePackages = params.getHmrcRulePackages(GovTalkHeaderConstants.NAMESPACE_GOVTALK_ENVELOPE);
            for (final String s : rulePackages) {
                validator.addBusinessRules(s);
            }

            final PostValidationDelegate delegate = validator.getDelegate();
            if (delegate instanceof HMRCValidationDelegate) {
                final HMRCValidationDelegate hmrcDelegate = (HMRCValidationDelegate) delegate;
                hmrcDelegate.setGovTalkHeaderDetails(govTalkHeaderCollector);
                hmrcDelegate.addResponseGenerator(new GovTalkEnvelopeGenerator(govTalkHeaderCollector));
            }
        }
    }

    public void destroy() {
        local.set(null);
    }
}
