package hmrc.validator;

import govtalk.header.GovTalkHeaderConstants;
import govtalk.header.GovTalkHeaderDetails;

import java.util.Date;

import bizrules.binding.ValueBinder;

public class GovTalkHeaderCollector extends KeyCollector implements GovTalkHeaderDetails {

    private Date dateStamp;

    private String messageType;

    private String correlationId;

    private String senderId;

    private String emailAddress;

    private String gatewayEnvelopeVersion;

    private String messageClass;

    private String gatewayTest = "0";

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { GovTalkHeaderConstants.NAMESPACE_GOVTALK_ENVELOPE };
    }

    @Override
    protected void initializeValueBindings() {
        final ValueBinder binder = getValueBinder();
        binder.add("/GovTalkMessage/Header/MessageDetails/CorrelationID", "correlationId");
        binder.add("/GovTalkMessage/Header/MessageDetails/GatewayTest", "gatewayTest");
        binder.add("/GovTalkMessage/Header/MessageDetails/Class", "messageClass");
        binder.add("/GovTalkMessage/EnvelopeVersion", "gatewayEnvelopeVersion");
        binder.add("/GovTalkMessage/Header/SenderDetails/IDAuthentication/SenderID", "senderId");
        binder.add("/GovTalkMessage/GovTalkDetails/Keys/Key", "key");
    }

    @Override
    protected void initializeEventBindings() {
    }

    public String getMessageClass() {
        return messageClass;
    }

    public void setMessageClass(final String messageClass) {
        this.messageClass = messageClass;
    }

    public String getCorrelationId() {
        return correlationId;
    }

    public void setCorrelationId(final String correlationId) {
        this.correlationId = correlationId;
    }

    public Date getDateStamp() {
        return (Date) dateStamp.clone();
    }

    public void setDateStamp(final Date dateStamp) {
        this.dateStamp = (Date) dateStamp.clone();
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public void setEmailAddress(final String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(final String messageType) {
        this.messageType = messageType;
    }

    public String getSenderId() {
        return senderId;
    }

    public void setSenderId(final String senderId) {
        this.senderId = senderId;
    }

    public void setGatewayEnvelopeVersion(final String v) {
        gatewayEnvelopeVersion = v;
    }

    public String getGatewayEnvelopeVersion() {
        return gatewayEnvelopeVersion;
    }

    public String getGatewayTest() {
        return gatewayTest;
    }

    public void setGatewayTest(final String gatewayTest) {
        this.gatewayTest = gatewayTest;
    }
}
