/**
 * 
 */
package hmrc.validator;

import xmldoc.Attribute;
import bizrules.AbstractElementProcessor;

/**
 * @author Doug Clinton
 * 
 */
public abstract class KeyCollector extends AbstractElementProcessor {

    private String currentKey;

    private String taxOfficeNumber;

    private String taxOfficeReference;

    public void setKey(final Attribute[] attributes) {
        currentKey = attributes[0].getValue();
    }

    public void setKey(final String value) {
        if (currentKey.equals("TaxOfficeReference")) {
            taxOfficeReference = value;
        } else if (currentKey.equals("TaxOfficeNumber")) {
            taxOfficeNumber = value;
        }
    }

    public String getTaxOfficeNumber() {
        return taxOfficeNumber;
    }

    public void setTaxOfficeNumber(final String taxOfficeNumber) {
        this.taxOfficeNumber = taxOfficeNumber;
    }

    public String getTaxOfficeReference() {
        return taxOfficeReference;
    }

    public void setTaxOfficeReference(final String taxOfficeReference) {
        this.taxOfficeReference = taxOfficeReference;
    }

}
