package hmrc.validator;

import bizrules.AbstractElementProcessor;
import ericResponse.output.PAYESubmissionDetails;

public class PAYEDetailCollector extends AbstractElementProcessor implements PAYESubmissionDetails {

    private final String targetNamespace;

    private String submissionType;

    public PAYEDetailCollector(final String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { targetNamespace };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/SubmissionType", "submissionType");
    }

    @Override
    protected void initializeEventBindings() {
    }

    public String getSubmissionType() {
        return submissionType;
    }

    public void setSubmissionType(final String submissionType) {
        this.submissionType = submissionType;
    }
}
