package hmrc.validator;

import bizrules.AbstractElementProcessor;
import ericResponse.output.IREnvelopeDetails;

public class StandardIREnvelopeCollector extends AbstractElementProcessor implements IREnvelopeDetails {

    private final String targetNamespace;

    private String irMark;

    private boolean testMessage;

    public StandardIREnvelopeCollector(final String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { targetNamespace };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/IRheader/IRmark", "irMark");
        getValueBinder().add("/IRenvelope/IRheader/TestMessage", "testMessage");
    }

    @Override
    protected void initializeEventBindings() {
    }

    public String getIRmark() {
        return irMark;
    }

    public void setIrMark(final String irMark) {
        this.irMark = irMark;
    }

    public boolean isTestMessage() {
        return testMessage;
    }

    public void setTestMessage(final boolean testMessage) {
        this.testMessage = testMessage;
    }

    public void setTestMessage(final String testMessage) {
        this.testMessage = testMessage.equals("1");
    }
}
