package hmrc.validator.result;

import govtalk.header.GovTalkHeaderDetails;
import hmrc.validator.HMRCValidationResultBean;

import java.math.BigDecimal;
import java.util.List;

import com.gsl.docValidator.ValidationResult;

import ericResponse.output.IREnvelopeDetails;
import ericResponse.output.error.EricResponseError;

/**
 * Provides an accessor-only interface to the HMRC validation result
 * information. HMRC validation implementations may wish to make use of this
 * interface to hide the setter methods on the HMRCValidationResultBean class
 * from the calling client.
 * 
 * @see HMRCValidationResultBean
 */
public interface HMRCValidationResult extends ValidationResult {

    /**
     * Gets the list of {@link EricResponseError} instances containing the
     * mapped errors generated while validating the document. Returns an empty
     * list if there were no errors mapped.
     * 
     * @return The list of ERIC errors generated while validating the document.
     */
    List<EricResponseError> getEricResponseErrors();

    /**
     * Gets the quality stage level 2 result for the document.
     * 
     * @see QSResult
     * 
     * @return The quality stage level 2 result for the document.
     */
    QSResult getQS2Result();

    /**
     * Gets the quality stage level 3 result for the document.
     * 
     * @see QSResult
     * 
     * @return The quality stage level 3 result for the document.
     */
    QSResult getQS3Result();

    /**
     * @return the total discrepancy from all the QS3 errors. This is the sum of
     *         the absolute values of the MonetaryDiscrepencies for the relevant
     *         errors.
     */
    BigDecimal getQS3MonetaryDiscrepancy();

    /**
     * Gets details from the GovTalk header found in the document.
     * 
     * @return Details from the GovTalk header found in the document.
     */
    GovTalkHeaderDetails getGovTalkHeaderDetails();

    /**
     * Gets details from the IR Envelope found in the document.
     * 
     * @return Details from the IR Envelope header found in the document.
     */
    IREnvelopeDetails getIrEnvelopeDetails();
}
