package hmrc.validator.result;

import java.io.Serializable;

/**
 * Holds the status of the validation at a particular Quality Standard (QS)
 * level.
 * 
 * @author Douglas Clinton
 * @since Jan 20, 2006
 */
public class QSResult implements Serializable {

    private ValidationStatus validationStatus;

    private int errorCount;

    public int getErrorCount() {
        return errorCount;
    }

    public void setErrorCount(final int errorCount) {
        this.errorCount = errorCount;
    }

    public ValidationStatus getValidationStatus() {
        return validationStatus;
    }

    public void setValidationStatus(final ValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    @Override
    public String toString() {
        return "QSResult[errorCount=" + errorCount + ", status='" + validationStatus + "']";
    }
}