package hmrc.validator.result;

import java.io.Serializable;

/**
 * @author Douglas Clinton
 * @since 27-Nov-2005
 */
public class ValidationStatus implements Serializable {

    public static final ValidationStatus PASSED = new ValidationStatus("Passed");

    public static final ValidationStatus FAILED = new ValidationStatus("Failed");

    public static final ValidationStatus TOLERATED = new ValidationStatus("Passed on tolerances");

    public static final ValidationStatus NOT_VALIDATED = new ValidationStatus("No tolerances applied");

    private final String statusString;

    private ValidationStatus(final String statusString) {
        this.statusString = statusString;
    }

    @Override
    public String toString() {
        return statusString;
    }
}
