package paye.eoy.bizrules;

import hmrc.bizrules.AbstractHMRCBusinessRule;

import java.util.HashSet;
import java.util.Set;

import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

public abstract class AbstractEOYBusinessRule extends AbstractHMRCBusinessRule {

    public AbstractEOYBusinessRule() {
    }

    protected abstract ActiveTaxYear[] getApplicableTaxYears();

    public boolean isActiveForTaxYear(final TaxYear taxYear) {
        boolean result = false;
        final TaxYear[] taxYears = getApplicableTaxYears();
        for (final TaxYear element : taxYears) {
            if (element == taxYear) {
                result = true;
                break;
            }
        }
        return result;
    }

    /**
     * The same namespace may be applicable for multiple tax years. This method
     * will return a list of unique namespace strings.
     * 
     * @return the namespace strings for all the tax years which this rule
     *         supports.
     */
    @Override
    public String[] getApplicableNamespaces() {
        final TaxYear[] taxYears = getApplicableTaxYears();
        final Set<String> namespaces = new HashSet<String>();
        for (final TaxYear element : taxYears) {
            namespaces.add(element.getIREnvelopeNamespaceString());
        }

        final String[] namespaceStrings = new String[namespaces.size()];
        int namespaceCounter = 0;
        for (final String namespaceString : namespaces) {
            namespaceStrings[namespaceCounter] = namespaceString;
            namespaceCounter++;
        }
        return namespaceStrings;
    }
}
