package paye.eoy.bizrules;

import java.text.ParseException;
import java.util.Date;
import java.util.logging.Logger;

import paye.multiyear.DateHelper;
import paye.multiyear.TaxYear;

import com.gsl.logging.LoggerFactory;

public class EOYSubmissionProperties {

    protected Logger logger = LoggerFactory.getLogger("bizrules");

    private TaxYear taxYear;

    public EOYSubmissionProperties() {
    }

    public void setPeriodEndDate(final String periodEndString) {
        Date periodEndDate = null;
        if (periodEndString != null && !periodEndString.equals("")) {
            try {
                periodEndDate = DateHelper.createDateFormat().parse(periodEndString);
            } catch (final ParseException e) {
                logger.warning("Could not parse period end date string: '" + periodEndString + "'");
            }
        }
        if (periodEndDate != null) {
            taxYear = TaxYear.estimateFromPeriodEndDate(periodEndDate);
        }
    }

    public TaxYear getTaxYear() {
        return taxYear;
    }
}
