package paye.eoy.bizrules;

import paye.multiyear.IRNamespaceMapping;
import paye.multiyear.TaxYear;

public class PAYEIRNamespaceMapping implements IRNamespaceMapping {

    private static final PAYEIRNamespaceMapping instance = new PAYEIRNamespaceMapping();

    private PAYEIRNamespaceMapping() {
    }

    public static PAYEIRNamespaceMapping getInstance() {
        return instance;
    }

    public static final String NAMESPACE_EOY_0809 = "http://www.govtalk.gov.uk/taxation/EOY/08-09/1";
    public static final String NAMESPACE_EOY_0910 = "http://www.govtalk.gov.uk/taxation/EOY/09-10/1";
    public static final String NAMESPACE_EOY_1011 = "http://www.govtalk.gov.uk/taxation/EOY/10-11/1";
    public static final String NAMESPACE_EOY_1112 = "http://www.govtalk.gov.uk/taxation/EOY/11-12/1";

    public static final String NAMESPACE_EOY_1213 = "http://www.govtalk.gov.uk/taxation/EOY/12-13/1";
    public static final String NAMESPACE_EOY_1314 = "http://www.govtalk.gov.uk/taxation/EOY/13-14/1";
    public static final String NAMESPACE_EOY_1415 = "http://www.govtalk.gov.uk/taxation/EOY/14-15/1";
    public static final String NAMESPACE_EOY_1516 = "http://www.govtalk.gov.uk/taxation/EOY/15-16/1";
    public static final String NAMESPACE_EOY_1617 = "http://www.govtalk.gov.uk/taxation/EOY/16-17/1";
    public static final String NAMESPACE_EOY_1718 = "http://www.govtalk.gov.uk/taxation/EOY/17-18/1";
    public static final String NAMESPACE_EOY_1819 = "http://www.govtalk.gov.uk/taxation/EOY/18-19/1";
    public static final String NAMESPACE_EOY_1920 = "http://www.govtalk.gov.uk/taxation/EOY/19-20/1";
    public static final String NAMESPACE_EOY_2021 = "http://www.govtalk.gov.uk/taxation/EOY/20-21/1";
    public static final String NAMESPACE_EOY_2122 = "http://www.govtalk.gov.uk/taxation/EOY/21-22/1";
    public static final String NAMESPACE_EOY_2223 = "http://www.govtalk.gov.uk/taxation/EOY/22-23/1";
    public static final String NAMESPACE_EOY_2324 = "http://www.govtalk.gov.uk/taxation/EOY/23-24/1";

    public String getIRNamespaceForTaxYear(final TaxYear taxYear) {
        if (TaxYear.TAX_YEAR_0809 == taxYear) {
            return NAMESPACE_EOY_0809;
        } else if (TaxYear.TAX_YEAR_0910 == taxYear) {
            return NAMESPACE_EOY_0910;
        } else if (TaxYear.TAX_YEAR_1011 == taxYear) {
            return NAMESPACE_EOY_1011;
        } else if (TaxYear.TAX_YEAR_1112 == taxYear) {
            return NAMESPACE_EOY_1112;
        } else if (TaxYear.TAX_YEAR_1213 == taxYear) {
            return NAMESPACE_EOY_1213;
        } else if (TaxYear.TAX_YEAR_1314 == taxYear) {
            return NAMESPACE_EOY_1314;
        } else if (TaxYear.TAX_YEAR_1415 == taxYear) {
            return NAMESPACE_EOY_1415;
        } else if (TaxYear.TAX_YEAR_1516 == taxYear) {
            return NAMESPACE_EOY_1516;
        } else if (TaxYear.TAX_YEAR_1617 == taxYear) {
            return NAMESPACE_EOY_1617;
        } else if (TaxYear.TAX_YEAR_1718 == taxYear) {
            return NAMESPACE_EOY_1718;
        } else if (TaxYear.TAX_YEAR_1819 == taxYear) {
            return NAMESPACE_EOY_1819;
        } else if (TaxYear.TAX_YEAR_1920 == taxYear) {
            return NAMESPACE_EOY_1920;
        } else if (TaxYear.TAX_YEAR_2021 == taxYear) {
            return NAMESPACE_EOY_2021;
        } else if (TaxYear.TAX_YEAR_2122 == taxYear) {
            return NAMESPACE_EOY_2122;
        }  else if (TaxYear.TAX_YEAR_2223 == taxYear) {
            return NAMESPACE_EOY_2223;
        }  else if (TaxYear.TAX_YEAR_2324 == taxYear) {
            return NAMESPACE_EOY_2324;
        } else {
            return null;
        }
    }

}
