/**
 * $Id$
 */
package paye.eoy.bizrules;

import java.util.logging.Level;

import paye.channel.SubmissionChannel;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;

/**
 * @author Douglas Clinton
 * @since Jan 23, 2006
 * 
 */
public class PAYESubmissionProperties extends EOYSubmissionProperties {

    private SubmissionType submissionType;

    private ReturnType returnType;

    private SubmissionChannel channel;

    public void setReturnType(final String returnTypeString) {
        try {
            this.returnType = ReturnType.fromString(returnTypeString);
        } catch (final IllegalArgumentException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void setSubmissionType(final String submissionTypeString) {
        try {
            this.submissionType = SubmissionType.fromString(submissionTypeString);
        } catch (final IllegalArgumentException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public SubmissionType getSubmissionType() {
        return submissionType;
    }

    public ReturnType getReturnType() {
        return returnType;
    }

    public void setChannel(final SubmissionChannel channel) {
        this.channel = channel;
    }

    public SubmissionChannel getChannel() {
        return channel;
    }
}
