/**
 * $Id: SubmissionPropertyCollector.java,v 1.5 2006/03/17 09:47:34 dec Exp $
 */
package paye.eoy.bizrules;

import paye.channel.SubmissionChannel;
import paye.multiyear.TaxYear;
import bizrules.AbstractElementProcessor;

/**
 * This object collects the basic details for the submission which are used by
 * all PAYE rules to decide if they are active. It is an optimisation so that
 * each PAYE business rule does not need to register for these values
 * individually. This greatly reduces the overall registration time.
 * 
 * @author Douglas Clinton
 * @since Feb 24, 2006
 * 
 */
public class PAYESubmissionPropertyCollector extends AbstractElementProcessor {
    /*
     * Initialized statically to prevent null pointer exceptions in unit tests.
     */
    private static ThreadLocal<PAYESubmissionProperties> properties = new ThreadLocal<PAYESubmissionProperties>();

    static {
        properties.set(new PAYESubmissionProperties());
    }

    public PAYESubmissionPropertyCollector(final SubmissionChannel submissionChannel) {
        final PAYESubmissionProperties props = new PAYESubmissionProperties();
        props.setChannel(submissionChannel);
        properties.set(props);
    }

    @Override
    protected void initializeValueBindings() {
        final PAYESubmissionProperties props = getProperties();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/SubmissionType", "submissionType", props);
        getValueBinder().add("/IRenvelope/EndOfYearReturn/ReturnType", "returnType", props);
        getValueBinder().add("/IRenvelope/IRheader/PeriodEnd", "PeriodEndDate", props);
    }

    @Override
    protected void initializeEventBindings() {
    }

    public static PAYESubmissionProperties getProperties() {
        return properties.get();
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return TaxYear.getUniqueNamespaces();
    }
}
