/**
 * 
 */
package paye.eoy.bizrules;

import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import bizrules.registry.DocumentEventDetail;

/**
 * This rule checks that an original return does not contain a P35Amended or
 * P14Amended part and that an amended return does not contain a P35 or P14
 * part. The schema can't check this because the choice is parameterized on the
 * value of the ReturnType field.
 * 
 * @author Doug Clinton
 * 
 */
public class ReturnTypeCrossCheckRule extends AbstractPAYEBusinessRule {

    public static final String AMENDED_CONTAINS_ORIGINAL_PART = "amended submission contains original part";

    public static final String ORIGINAL_CONTAINS_AMENDED_PART = "original submission contains amended part";

    /**
     * Used to avoid duplication of errors
     */
    boolean errorAlreadyRaised = false;

    private final String[] subcodes = { AMENDED_CONTAINS_ORIGINAL_PART, ORIGINAL_CONTAINS_AMENDED_PART };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P35Amended", "amendedPart");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P35", "originalPart");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14Amended", "amendedPart");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14", "originalPart");
    }

    public void amendedPart(final DocumentEventDetail detail) {
        if (!errorAlreadyRaised && getReturnType() == ReturnType.ORIGINAL) {
            raiseError(ORIGINAL_CONTAINS_AMENDED_PART);
            errorAlreadyRaised = true;
        }
    }

    public void originalPart(final DocumentEventDetail detail) {
        if (!errorAlreadyRaised && getReturnType() == ReturnType.AMENDED) {
            raiseError(AMENDED_CONTAINS_ORIGINAL_PART);
            errorAlreadyRaised = true;
        }
    }

    @Override
    protected void initializeValueBindings() {
        // no value bindings
    }

    @Override
    protected String[] getInvocationPoints() {
        // no invocation points
        return new String[] {};
    }

    public void processRule() {
        // should never be called
    }

}
