package paye.eoy.bizrules.consolidated;

import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Doug
 * @since 15/7/2010
 */
public class ASPPRecoveredRuleOriginal extends AbstractRecoveredRuleConsolidated {

    public ASPPRecoveredRuleOriginal() {
        setRuleName("ASPPRecoveredRule");
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalASPP", "value");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "handleError");
    }

    @Override
    public boolean handleError(final DocumentError documentError) {
        return super.handleError(documentError);
    }
}
