package paye.eoy.bizrules.consolidated;

import hmrc.bizrules.AbstractHMRCBusinessRule;

import java.text.ParseException;
import java.util.Date;

import paye.multiyear.DateHelper;
import paye.multiyear.TaxYear;

public abstract class AbstractConsolidatedRule extends AbstractHMRCBusinessRule {
    private TaxYear taxYear;

    public AbstractConsolidatedRule() {
        super();
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1.5", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/2",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    public boolean isActive() {
        /*
         * Always true because it is only bound in the consolidated namespace
         * and for a consolidated submission we always want to run the rule.
         */
        return true;
    }

    public void setPeriodEndDate(final String periodEndString) {
        Date periodEndDate = null;
        if (periodEndString != null && !periodEndString.equals("")) {
            try {
                periodEndDate = DateHelper.createDateFormat().parse(periodEndString);
            } catch (final ParseException e) {
                // stifle
            }
        }
        if (periodEndDate != null) {
            taxYear = TaxYear.estimateFromPeriodEndDate(periodEndDate);
        }
    }

    public TaxYear getTaxYear() {
        return taxYear;
    }

}