package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalTotalizer;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import bizrules.errors.MonetaryDiscrepancy;

public abstract class AbstractPartTotalsRule extends AbstractConsolidatedRule {

    public static final String BAD_TOTAL = "bad total";

    private final BigDecimalTotalizer partTotals = new BigDecimalTotalizer();

    private BigDecimal p35Value = BigDecimalUtil.toBigDecimal("0.00");

    @Override
    public String[] getSubcodes() {
        return new String[] { BAD_TOTAL };
    }

    @Override
    protected void initializeEventBindings() {
        // none
    }

    @Override
    protected void initializeValueBindings() {
        for (final String path : getPartTotalPaths()) {
            getValueBinder().add(path, "partTotals");
        }

        for (final String path : getP35Paths()) {
            getValueBinder().add(path, "p35Value");
        }

        getValueBinder().add("/IRenvelope/IRheader/PeriodEnd", "periodEndDate");
    }

    protected abstract String[] getPartTotalPaths();

    protected abstract String[] getP35Paths();

    public void setP35Value(final String value) {
        p35Value = BigDecimalUtil.toBigDecimal(value);
    }

    public void setPartTotals(final String value) {
        partTotals.add(value);
    }

    public void processRule() {
        if (!p35Value.equals(partTotals.getTotal())) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(partTotals.getTotal(), p35Value));
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

}