/**
 * 
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author doug
 * 
 */
public abstract class AbstractTotalAmountPayable extends AbstractConsolidatedRule {

    public AbstractTotalAmountPayable() {
        setRuleName("TotalAmountPayableRule");
    }

    public static final String BAD_TOTAL = "bad total";

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.BLANK };

    private String totalPayable;

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    public void setTotalPayable(final String value) {
        this.totalPayable = value;
    }

    protected String getTotalPayable() {
        return totalPayable;
    }

    @Override
    protected void initializeValueBindings() {
        initializeLocalValueBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable", "totalPayable");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable", "totalPayable");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable", "handleError");
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    protected abstract void initializeLocalValueBindings();

    public final void processRule() {
        final BigDecimal suppliedValue = BigDecimalUtil.toBigDecimal(getTotalPayable());
        final BigDecimal calculatedTotal = getCalculatedTotal();

        if (suppliedValue.compareTo(calculatedTotal) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculatedTotal, suppliedValue));
        }
    }

    protected abstract BigDecimal getCalculatedTotal();

}
